/*
 * Decompiled with CFR 0.152.
 */
package feedMe;

import feedMe.Worker;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GUI
extends JFrame
implements ActionListener,
ChangeListener {
    public static final int DEFAULT_CLICK = 50;
    private Worker worker;
    private JLabel lblTitle = new JLabel("Feed Me!");
    private Button btnMode = new Button("OFF");
    private JProgressBar progressBar = new JProgressBar(0, 100);
    private JSlider slider = new JSlider(0, 10, 100, 50);
    private JLabel lblClickSetting = new JLabel();
    private Button btnShiftModifier = new Button("SHIFT MODIFIER");
    private JLabel lblHotkeyTitle = new JLabel();
    private JLabel lblHotkey = new JLabel();
    private Button btnSetHotkey = new Button("set");

    public GUI(Worker worker, String version) {
        this.worker = worker;
        this.setTitle("feedMe! v" + version);
        this.setSize(300, 250);
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        worker.setClickNum(50);
        this.setClickLabel();
        worker.setup(this.lblHotkey, this.progressBar, this.btnMode);
        this.addGUIObjects();
        this.configGUIObjects();
        this.addListeners();
    }

    private void addGUIObjects() {
        this.setLayout(new BorderLayout());
        JPanel content = new JPanel();
        this.add((Component)content, "Center");
        content.setLayout(new GridLayout(2, 1));
        JPanel pnlMode = new JPanel();
        content.add(pnlMode);
        pnlMode.setLayout(new BorderLayout());
        pnlMode.add((Component)this.btnMode, "Center");
        pnlMode.add((Component)this.progressBar, "South");
        JPanel pnlSettings = new JPanel();
        pnlSettings.setLayout(new BorderLayout());
        pnlSettings.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        content.add(pnlSettings);
        pnlSettings.add((Component)this.slider, "Center");
        pnlSettings.add((Component)this.lblClickSetting, "After");
        pnlSettings.add((Component)this.btnShiftModifier, "South");
        JPanel pnlHotkey = new JPanel();
        this.add((Component)pnlHotkey, "South");
        pnlHotkey.setLayout(new FlowLayout());
        pnlHotkey.add(this.lblHotkeyTitle);
        pnlHotkey.add(this.lblHotkey);
        pnlHotkey.add(this.btnSetHotkey);
    }

    private void configGUIObjects() {
        this.lblTitle.setFont(new Font("Arial", 1, 32));
        this.lblTitle.setHorizontalAlignment(0);
        this.add((Component)this.lblTitle, "North");
        this.btnMode.setBackground(Color.RED);
        this.btnMode.setFont(new Font("Arial", 0, 16));
        this.progressBar.setValue(0);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(20);
        this.slider.setMinorTickSpacing(10);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(true);
        this.lblClickSetting.setPreferredSize(new Dimension(60, 0));
        this.btnShiftModifier.setBackground(Color.LIGHT_GRAY);
        this.lblHotkeyTitle.setText("Hotkey:");
        this.lblHotkey.setText("Not Assigned");
        this.lblHotkey.setPreferredSize(new Dimension(100, 15));
    }

    private void addListeners() {
        this.btnSetHotkey.addActionListener(this);
        this.btnMode.addActionListener(this);
        this.btnShiftModifier.addActionListener(this);
        this.slider.addChangeListener(this);
    }

    private void setClickLabel() {
        int value = this.worker.getShiftModifier() ? (int)((double)this.slider.getValue() * 0.25) : (int)((double)this.slider.getValue() * 0.1);
        String txt = "Units: " + value + "k";
        this.lblClickSetting.setText(txt);
        this.worker.setClickNum(this.slider.getValue());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.btnMode) {
            int mode = this.worker.toggleMode();
            if (mode == -1) {
                JOptionPane.showMessageDialog(this, "Hotkey has not been set", "ERROR", 0);
            } else if (mode == 0) {
                this.btnMode.setLabel("OFF");
                this.btnMode.setBackground(Color.RED);
                this.btnSetHotkey.setEnabled(true);
            } else if (mode == 1) {
                this.btnMode.setLabel("ARMED");
                this.btnMode.setBackground(Color.YELLOW);
                this.btnSetHotkey.setEnabled(false);
            } else if (mode == 2) {
                this.btnMode.setLabel("RUNNING");
                this.btnMode.setBackground(Color.GREEN);
            }
        } else if (event.getSource() == this.btnShiftModifier) {
            boolean value = this.worker.toggleShiftModifier();
            if (value) {
                this.btnShiftModifier.setBackground(Color.CYAN);
            } else {
                this.btnShiftModifier.setBackground(Color.LIGHT_GRAY);
            }
            this.setClickLabel();
        } else if (event.getSource() == this.btnSetHotkey) {
            this.worker.setHotkey();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.slider) {
            this.setClickLabel();
        }
    }
}

