/*
 * Decompiled with CFR 0.152.
 */
package feedMe;

import feedMe.Clicker;
import java.awt.Button;
import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.jnativehook.GlobalScreen;
import org.jnativehook.NativeHookException;
import org.jnativehook.keyboard.NativeKeyEvent;
import org.jnativehook.keyboard.NativeKeyListener;

public class Worker
implements NativeKeyListener {
    public static final int MODE_OFF = 0;
    public static final int MODE_ARM = 1;
    public static final int MODE_RUN = 2;
    private int currentMode = 0;
    private int clickNum = 10;
    private boolean shiftModifier = false;
    private int modifierCode = 0;
    private int keyCode = 0;
    private boolean setHotkeyActive = false;
    private JLabel lblHotkey;
    private JProgressBar progress;
    private Button btnMode;
    private Clicker clicker;

    public Worker() {
        Logger logger = Logger.getLogger(GlobalScreen.class.getPackage().getName());
        logger.setLevel(Level.WARNING);
        logger.setUseParentHandlers(false);
    }

    public void setup(JLabel lblHotkey, JProgressBar progress, Button btnMode) {
        this.lblHotkey = lblHotkey;
        this.progress = progress;
        this.btnMode = btnMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int toggleMode() {
        if (this.currentMode == 0) {
            if (this.keyCode == 0) return -1;
            this.currentMode = 1;
            this.keyMonOn();
            return this.currentMode;
        } else if (this.currentMode == 1) {
            this.currentMode = 0;
            this.keyMonOff();
            return this.currentMode;
        } else {
            if (this.currentMode != 2) return this.currentMode;
            this.clicker.stop();
        }
        return this.currentMode;
    }

    public boolean toggleShiftModifier() {
        this.shiftModifier = !this.shiftModifier;
        return this.shiftModifier;
    }

    public boolean getShiftModifier() {
        return this.shiftModifier;
    }

    public void setHotkey() {
        this.setHotkeyActive = true;
        this.lblHotkey.setText("");
        this.keyMonOn();
    }

    public void setClickNum(int clickNum) {
        this.clickNum = clickNum;
    }

    public void clickDone() {
        this.clicker = null;
        this.currentMode = 1;
        this.btnMode.setBackground(Color.YELLOW);
        this.btnMode.setLabel("ARMED");
    }

    private void keyMonOn() {
        try {
            GlobalScreen.registerNativeHook();
        }
        catch (NativeHookException ex) {
            System.err.println("There was a problem registering the native hook.");
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    private void keyMonOff() {
        try {
            GlobalScreen.unregisterNativeHook();
        }
        catch (NativeHookException ex) {
            System.err.println("There was a problem registering the native hook.");
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    @Override
    public void nativeKeyPressed(NativeKeyEvent key) {
        boolean hotkeyPressed;
        boolean bl = hotkeyPressed = key.getKeyCode() == this.keyCode && key.getModifiers() == this.modifierCode;
        if (!hotkeyPressed && this.shiftModifier) {
            int modifierNoShift = key.getModifiers() & 0xFFFFFFEE;
            boolean bl2 = hotkeyPressed = key.getKeyCode() == this.keyCode && modifierNoShift == this.modifierCode;
        }
        if (this.setHotkeyActive) {
            if (key.isActionKey()) {
                this.lblHotkey.setText(NativeKeyEvent.getKeyText(key.getKeyCode()));
                this.modifierCode = key.getModifiers();
                this.keyCode = key.getKeyCode();
            } else {
                String keyText = "";
                if (key.getModifiers() != 0) {
                    keyText = String.valueOf(NativeKeyEvent.getModifiersText(key.getModifiers())) + " + ";
                }
                keyText = String.valueOf(keyText) + NativeKeyEvent.getKeyText(key.getKeyCode());
                this.lblHotkey.setText(keyText);
                this.modifierCode = key.getModifiers();
                this.keyCode = key.getKeyCode();
            }
        } else if (hotkeyPressed) {
            if (this.currentMode == 2) {
                this.clicker.stop();
            } else {
                this.clicker = new Clicker(this, this.progress, this.clickNum, this.shiftModifier);
                Thread thread = new Thread(this.clicker);
                this.currentMode = 2;
                this.btnMode.setBackground(Color.GREEN);
                this.btnMode.setLabel("RUNNING");
                thread.start();
            }
        }
    }

    @Override
    public void nativeKeyReleased(NativeKeyEvent nativeEvent) {
        if (this.setHotkeyActive) {
            this.setHotkeyActive = false;
            this.keyMonOff();
        }
    }

    @Override
    public void nativeKeyTyped(NativeKeyEvent nativeEvent) {
    }
}

